/*
 * Decompiled with CFR 0.152.
 */
package com.sync.delta;

import java.io.Serializable;
import java.util.Vector;

class HistoryDataSeries
implements Serializable {
    public Vector data;
    int seriesSize;
    int maxRows;
    double initTime;

    HistoryDataSeries() {
    }

    public void HistoryDataSeries() {
    }

    public void setSize(int rows, int size) {
        this.maxRows = rows;
        this.seriesSize = size;
        this.data = new Vector(this.maxRows + 1);
        for (int i = 0; i < this.maxRows + 1; ++i) {
            Vector row = new Vector(this.seriesSize + 1);
            this.data.addElement(row);
        }
        this.initTime = System.currentTimeMillis();
    }

    public int size() {
        return this.maxRows + 1;
    }

    public int getSeriesSize() {
        Vector row = (Vector)this.data.elementAt(0);
        return row.size();
    }

    public synchronized void reset() {
        this.data = null;
        this.data = new Vector(this.maxRows + 1);
        for (int i = 0; i < this.maxRows + 1; ++i) {
            Vector row = new Vector(this.seriesSize + 1);
            this.data.addElement(row);
        }
        this.initTime = System.currentTimeMillis();
    }

    public synchronized void update(double[] values) {
        if (this.data == null) {
            System.out.println("null data array");
        } else {
            Vector row = (Vector)this.data.elementAt(0);
            Double ts = new Double(((double)System.currentTimeMillis() - this.initTime) / (double)1000);
            row.addElement(ts);
            if (row.size() > this.seriesSize) {
                row.removeElementAt(0);
            }
            for (int i = 1; i < this.maxRows + 1; ++i) {
                row = (Vector)this.data.elementAt(i);
                row.addElement(new Double(values[i - 1]));
                if (row.size() <= this.seriesSize) continue;
                row.removeElementAt(0);
            }
        }
    }
}

